#include <GE7000_Interface.h>
#include <GE7000_Parallel.h>
#include <GE7000_Serial_Async.h>
#include <GE7000_Serial_Sync.h>
#include <GE7000_Serial_SPI.h>
#include <Noritake_VFD_GE7000.h>

// ****************************************************
// ****************************************************
// Uncomment one of the communication interfaces below.
//
//GE7000_Serial_Async interface(38400,3, 5, 7); // BAUD RATE,SIN,BUSY,RESET
//GE7000_Serial_Sync interface(3, 5, 6, 7); // SIN,BUSY,SCK,RESET
//GE7000_Serial_SPI interface(3, 5, 6, 7, 8); // OUT,BUSY,SCK,RESET,CS
//
//Parallel interface only works on GE256X64B-7032B module
//GE7000_Parallel interface('R', 8,9,10,11, 0,1,2,3,4,5,6,7); // Module Pin#3=RESET; BUSY,RESET,WR,RD,D0-D7
//GE7000_Parallel interface('B', 8,9,10,11, 0,1,2,3,4,5,6,7); // Module Pin#3=BUSY; BUSY,RESET,WR,RD,D0-D7
//GE7000_Parallel interface('N', 8,9,10,11, 0,1,2,3,4,5,6,7); // Module Pin#3=nothing; BUSY,RESET,WR,RD,D0-D7
//
// ****************************************************
// ****************************************************

Noritake_VFD_GE7000 vfd;

// 140x16 image "logo16"
// This image data was provided by the Noritake Bitmap Image Tool for GU-7000
const static uint8_t image[] = {
  0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x06,0x00,0x06,0x00,0x0c,0x00,0x18,0x00,0x30,
  0x00,0x60,0x00,0xc0,0x03,0x00,0x07,0xff,0x1f,0xff,0x1f,0x8c,0x00,0x18,0x00,0x20,
  0x00,0xc0,0x01,0x8e,0x03,0x3f,0x06,0x71,0x0c,0x61,0x18,0xe3,0x30,0xde,0x30,0xdc,
  0x60,0x79,0x60,0x17,0x60,0x3e,0x60,0x3c,0xc0,0x70,0xc0,0xe0,0xc0,0x60,0xc0,0x70,
  0x00,0xf0,0x00,0x56,0x00,0x3f,0x00,0x3d,0x00,0x71,0x00,0xe2,0x00,0x06,0x06,0x0f,
  0x04,0x1f,0x00,0x79,0x06,0xe2,0x07,0xc6,0x07,0x0c,0x0e,0x1f,0x0e,0x39,0x04,0x61,
  0x00,0x42,0x00,0xcf,0x00,0xdf,0x00,0x7a,0x00,0x62,0x00,0x45,0x00,0x0f,0x00,0x1e,
  0x00,0x3c,0x00,0x70,0x01,0xee,0x03,0xcf,0x0f,0xc9,0x1c,0xc9,0x18,0xf9,0x00,0x71,
  0x00,0x02,0x00,0x3e,0x00,0x7f,0x00,0x65,0x00,0xc9,0x00,0xf3,0x00,0x46,0x00,0x04,
  0x00,0x0c,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,
  0x00,0x1f,0x00,0xff,0x07,0xff,0x07,0xff,0x67,0xf0,0xf7,0xc0,0xf0,0x00,0xe0,0x06,
  0xc0,0x1f,0x06,0xff,0x07,0xff,0x1f,0xff,0x7f,0xf0,0xff,0xc0,0xfe,0x00,0xfe,0x00,
  0xc4,0x0f,0x00,0x7f,0x07,0xff,0x07,0xfe,0x07,0xf8,0x07,0xe0,0x07,0x00,0x06,0x00,
  0x07,0x80,0x07,0xc0,0x07,0xc0,0x07,0xc0,0x07,0x0e,0x00,0x3f,0x00,0xff,0x03,0xff,
  0x07,0xff,0x07,0xe3,0x07,0x87,0x06,0x3f,0x06,0xff,0x07,0xfe,0x07,0xf8,0x07,0xe0,
  0x07,0x80,0x00,0x06,0x00,0x3f,0x07,0xff,0x07,0xff,0x07,0xf8,0x07,0xe0,0x07,0x86,
  0x03,0x3f,0x06,0xff,0x07,0xff,0x07,0xff,0x07,0xf0,0x07,0x80,0x38,0x00,0x38,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

void setup() {
  _delay_ms(500);           // wait for device to power up
  vfd.begin(256, 64);       // 256x64 module
  // Enter the 4-digit model class number
  // E.g. 7040 for GU140X16G-7040A
  vfd.interface(interface); // select which interface to use
  vfd.isModelClass(7933);
  vfd.isGeneration('B');
  vfd.GE7000_reset();       // reset module
  vfd.GE7000_init();        // initialize module
  
  // A 140x16 image must be loaded on the
  // module's Flash ROM address 0x00000
  //Save an image to FROM. Don't use PROGMEM for image data.
  //WARNING: FROM has a limited number or rewrite cycles. Write to FROM only when necessary.
  vfd.GE7000_memoryRewriteStart();
  vfd.GE7000_setFROMImage(0, 280, image);
  vfd.GE7000_memoryRewriteEnd();
  
  vfd.GE7000_drawFROMImage(0, 16, 140, 16); // logo16.jpg
}

void loop() {
}

