#include <string.h>
 
// sݒ | Pin assignments
#define GT_DTR 4      // DTR
#define GT_DSR 6      // DSR
#define GT_TRDY 7     // TRDY <--gp | unused in this sample
 
 
void setup() {
  //  s̐ݒ | Pin setting
  pinMode(GT_DTR, INPUT);
  pinMode(GT_DSR, OUTPUT);
  pinMode(GT_TRDY, INPUT);
  digitalWrite(GT_DSR, LOW);
 
 // VAʐM̏ | Serial communication initialization
  Serial.begin(38400); // 38400bps Baud rate
  Serial.setTimeout(100); // Serial timeout
 
 
 
  // [^[̍ŏlƍőlݒ肷 | Set min and max values for meter
  setMeterRange(0, 160);
}
 
void loop() {
  // ZT[lǂݎ | Read value from sensor
  int sensorValue = analogRead(A0);
 
  // ZT[̒l0`160͈̔͂Ƀ}bsOAɎ߂ | Map the sensor value to the range 0-160 and constrain within limits
  int meterValue = constrain(map(sensorValue, 0, 1023, 160, 0), 0, 160);
 
 
  // [^[̒lGT-SPɑM | Send meter value to GT-SP
  sendMeterValue(meterValue);
 
  // [^[̎wi摜 | Change background image of the meter
  updateMeterBackground(meterValue);
 
  // GT-SP̃eLXgIuWFNgiIuWFNgNo.2jɒl\ | Display the value in the text object (Object No.2) on GT-SP
  gtsp_ObjPrpSet_string(2, 0x40, String(meterValue));
 
  delay(100); // Wait for 100 milliseconds
}
 
// GT-SP̃[^[̍ŏlƍőlݒ |  Set min and max values for meter on GT-SP
void setMeterRange(int minValue, int maxValue) {
  gtsp_ObjPrpSet_val(0, 0x1E, 4, minValue); // Set minimum value
  gtsp_ObjPrpSet_val(0, 0x1F, 4, maxValue); // Set maximum value
}
 
// GT-SPɒl𑗐M | Send value to GT-SP
void sendMeterValue(int value) {
  gtsp_ObjPrpSet_val(0, 0x10, 4, value);
}
 
// [^[̎wi摜ύX | Change background image of the meter
void updateMeterBackground(int value) {
  if (value <= 100) {
    Serial.println("Switching to Image0 (CNTS_SEL = 0)");
    gtsp_ObjPrpSet_val(0, 0x14, 1, 0); // CNTS_SEL = 0: Background Image0
  } else {
    Serial.println("Switching to Image1 (CNTS_SEL = 1)");
    gtsp_ObjPrpSet_val(0, 0x14, 1, 1); // CNTS_SEL = 1: Background Image1
  }
}
 
/********************** GT-SP֐ | Function for GT-SP **********************/
////////////////////////////////////////////////////
// IuWFNgR}h-vpeBǂݏoilpj| Read property value (for Value)
////////////////////////////////////////////////////
unsigned long gtsp_ObjPrpRead_val(int obj, int prp, int ln) {
  unsigned long val;

  gt_print("CMD"); // R}hwb_ | Command header
  gt_put(0xd4); // IuWFNg-vpeBݒR}h | Object-Property Setting
  gt_put(obj >> 0); // IuWFNgNo. ʃoCg | Object No. Lower byte
  gt_put(obj >> 8); // IuWFNgNo. ʃoCg | Object No. Upper byte
  gt_put(prp >> 0); // vpeBNo. ʃoCg | Property No. Lower byte
  gt_put(prp >> 8); // vpeBNo. ʃoCg | Property No. Upper byte
  gt_put(ln >> 0); // f[^ ŉʃoCg | Data length Least significant byte
  gt_put(ln >> 8); // f[^ ʃoCg | Data length second byte
  gt_put(ln >> 16); // f[^ ʃoCg | Data length third byte
  gt_put(ln >> 24); // f[^ ŏʃoCg | Data length Most significant byte

  // vpeBf[^M | Property data received
  while (Serial.available() == 0) {}
  val = gtsp_signal_read_val();
  return val;
}

////////////////////////////////////////////////////
// f[^Mipj| Receive data from GT-SP (for String)
////////////////////////////////////////////////////
String gtsp_signal_read() {
  byte res_dl[4] = "";
  unsigned long dl;
  char res_data_char[255] = "";

  if (Serial.find("RESb", 4)) {
    Serial.readBytes(res_dl, 4); // f[^o | Data-length extraction
    dl = (unsigned long)(res_dl[0] + (res_dl[1] << 8) + (res_dl[2] << 16) + (res_dl[3] << 24)); // f[^ϊ | Data length
    Serial.readBytes(res_data_char, dl); // f[^o | Read data
    Serial.print("Received data: ");
    for (unsigned int i = 0; i < dl; i++) {
      Serial.print(res_data_char[i], HEX);
      Serial.print(" ");
    }
    Serial.println();
    return String(res_data_char); // String type conversion, return
  }
  return "";
}
 
////////////////////////////////////////////////////
// 1byteM | Send byte to GT-SP
////////////////////////////////////////////////////
void gt_put(unsigned char onebyte) {
  while (digitalRead(GT_DTR) == HIGH) {} // busycheck
  Serial.write(onebyte);
}

////////////////////////////////////////////////////
// 񑗐M | Send String to GT-SP
////////////////////////////////////////////////////
void gt_print(String val) {
  int val_i;
  // 1M | Send string per one byte
  for (val_i = 0; val_i < val.length(); val_i++) {
    while (digitalRead(GT_DTR) == HIGH) {} // busycheck
    Serial.print(val.substring(val_i, val_i + 1));
  }
}
