#include <string.h>

// ピン設定 | Pin assignments
#define GT_DTR 4      // DTR
#define GT_DSR 6      // DSR
#define GT_TRDY 7     // TRDY <--未使用 | unused in this sample

void setup() {
  pinMode(GT_DTR, INPUT);
  pinMode(GT_DSR, OUTPUT);
  pinMode(GT_TRDY, INPUT);

  Serial.begin(38400);
  Serial.setTimeout(100);

  delay(1000);  // 初期化待ち
}

void loop() {
  // ポテンショメーターの値を読みとる
  int sensorValue = analogRead(A1);         // 0〜1023
  sensorValue = 1023 - sensorValue;  // 値を反転する
  

  // オブジェクト 0, プロパティ 0x40 に値を送信
  gtsp_ObjPrpSet_val(0, 0x40, 4, sensorValue);

   Serial.println(sensorValue);       // 値をシリアルモニターに表示

  delay(100);  // 100ms間隔で更新
}
/********************** GT-SP関数 | Function for GT-SP **********************/

////////////////////////////////////////////////////
// オブジェクト制御コマンド - プロパティ設定 (数値用) | Object Control Command - Property Setting (for Value)
////////////////////////////////////////////////////
void gtsp_ObjPrpSet_val(int obj, int prp, int ln, unsigned long val) {
  gt_print("CMD");     // コマンドヘッダ | Command header
  gt_put(0xd3);        // オブジェクト-プロパティ設定コマンド | Object-Property Setting
  gt_put(obj >> 0);    // オブジェクトNo. 下位バイト | Object No. Lower byte
  gt_put(obj >> 8);    // オブジェクトNo. 上位バイト | Object No. Upper byte
  gt_put(prp >> 0);    // プロパティNo. 下位バイト | Property No. Lower byte
  gt_put(prp >> 8);    // プロパティNo. 上位バイト | Property No. Upper byte
  gt_put(ln >> 0);     // データ長 最下位バイト | Data length Least significant byte
  gt_put(ln >> 8);     // データ長 下位バイト | Data length second byte
  gt_put(ln >> 16);    // データ長 上位バイト | Data length third byte
  gt_put(ln >> 24);    // データ長 最上位バイト | Data length Most significant byte
  if (ln >= 1) gt_put(val >> 0);
  if (ln >= 2) gt_put(val >> 8);
  if (ln >= 3) gt_put(val >> 16);
  if (ln >= 4) gt_put(val >> 24);
}

////////////////////////////////////////////////////
// 1byte送信 | Send byte to GT-SP
////////////////////////////////////////////////////
void gt_put(unsigned char onebyte) {
  while (digitalRead(GT_DTR) == HIGH) {} // busycheck
  Serial.write(onebyte);
}

////////////////////////////////////////////////////
// 文字列送信 | Send String to GT-SP
////////////////////////////////////////////////////
void gt_print(String val) {
  int val_i;
  // 文字列を1文字ずつ送信 | Send string per one byte
  for (val_i = 0; val_i < val.length(); val_i++) {
    while (digitalRead(GT_DTR) == HIGH) {} // busycheck
    Serial.print(val.substring(val_i, val_i + 1));
  }
}
