#include <Arduino.h>
#include <string.h>  
#include "DHT.h"      // 追加: DHT温湿度センサー用 | For DHT temperature and humidity sensor
 
// ピン設定 | Pin assignments
#define GT_DTR 4  //DTR
#define GT_DSR 6  //DSR
#define GT_TRDY 7 // TRDY <--未使用 | unused in this sample
 
// 追加: DHT設定（温度のみ使用） | Added: DHT configuration (temperature only)
#define DHT_SENSOR_PIN 10
#define DHT_SENSOR_TYPE DHT11
DHT dht(DHT_SENSOR_PIN, DHT_SENSOR_TYPE);
 
// 温度計測間隔設定 | Temperature measurement interval settings
unsigned long previousMillis = 0;
 
// グラフ設定 | Graph settings
int graphval[20];
int arraysize = 20; // 配列の要素数 | Array size
int count = 0;
 
void setup() {
  pinMode(GT_DTR, INPUT);
  pinMode(GT_DSR, OUTPUT);
  pinMode(GT_TRDY, INPUT);
 
  Serial.begin(38400);
  Serial.setTimeout(100);
  delay(500);  // 初期化待ち | Wait for initialization
 
  dht.begin(); // DHT初期化 | Initialize DHT sensor
 
  // グラフ送信用配列初期化 | Initialize array for sending graph data
  for (int i = 0; i < arraysize; i++) {
    graphval[i] = 0x8000; /
  }
}
 
 
 
void loop(){
  unsigned long currentMillis = millis(); // 現在時刻の取得 | Get current time
 
 // 2秒毎に実行する処理 | Execute process every 2 seconds
  if (currentMillis - previousMillis >= 2000) {
 
    float t_raw = dht.readTemperature(true); // 温度データ取得 | Read temperature data
    
    // 温度データがあれば処理 | If temperature data is valid, process it
    if (!isnan(t_raw)) {
 
      // 温度データを配列に送信する処理 | Process to send temperature data into the array
      if (count < arraysize) {
        // 配列データが全て埋まっていないとき | When the array is not yet full
        graphval[count++] = t_raw; // 末尾に追加 | Add to the end
      } else {
        // 配列データが全て埋まっているとき | When the array is full
        memmove(&graphval[0], &graphval[1], (arraysize - 1) * sizeof(int)); // 配列データを一つ前にシフト | Shift array data forward by one
        graphval[arraysize-1] = t_raw; // 末尾に追加 | Add to the end
      }
      
      gtsp_ObjPrpSet_string(1, 0x40, String(t_raw, 1)); //温度配列をグラフに送信 | Send temperature array to the graph
      gtsp_ObjPrpSet_Graphval(0, 0x40, graphval, arraysize); //温度配列をグラフに送信 | Send temperature array to the graph
 
    }
    previousMillis = currentMillis; // 時間をリセット | Reset the timer
  }
 
 
}
 
/********************** GT-SP関数 | Function for GT-SP **********************/
 
////////////////////////////////////////////////////
// オブジェクト制御コマンド - プロパティ設定 (グラフ値2byte送信用) | Object Control Command - Property Setting (for Graph Value - 2byte)
////////////////////////////////////////////////////
void gtsp_ObjPrpSet_Graphval(int obj, int prp, int graphval[], int arraysize) {  
  int val;
  int ln = arraysize * 2;
  gt_print("CMD");     // コマンドヘッダ | Command header
  gt_put(0xd3);        // オブジェクト-プロパティ設定コマンド | Object-Property Setting
  gt_put(obj >> 0);    // オブジェクトNo. 下位バイト | Object No. Lower byte
  gt_put(obj >> 8);    // オブジェクトNo. 上位バイト | Object No. Upper byte
  gt_put(prp >> 0);    // プロパティNo. 下位バイト | Property No. Lower byte
  gt_put(prp >> 8);    // プロパティNo. 上位バイト | Property No. Upper byte
  gt_put(ln >> 0);     // データ長 最下位バイト | Data length Least significant byte
  gt_put(ln >> 8);     // データ長 下位バイト | Data length second byte
  gt_put(ln >> 16);    // データ長 上位バイト | Data length third byte
  gt_put(ln >> 24);    // データ長 最上位バイト | Data length Most significant byte
  for (int i = 0; i < arraysize; i++) { 
    val = graphval[i];
    gt_put(val >> 0);
    gt_put(val >> 8);
  }
}
 
 
 
////////////////////////////////////////////////////
//  オブジェクト制御コマンド - プロパティ設定 (文字列用) | Object Control Command -Property Setting (for String)
////////////////////////////////////////////////////
void gtsp_ObjPrpSet_string(int obj, int prp, String val )
{
  gt_print("CMD");     //コマンドヘッダ | Command header
  gt_put(0xd3);        //オブジェクト-プロパティ設定コマンド | Object-Property Setting
  gt_put(obj >> 0);    //オブジェクトNo. 下位バイト | Object No. Lower byte
  gt_put(obj >> 8);    //オブジェクトNo. 上位バイト| Object No. Upper byte
  gt_put(prp >> 0);    //プロパティNo. 下位バイト | Property No. Lower byte 
  gt_put(prp >> 8);    //プロパティNo. 上位バイト| Property No. Upper byte 
  gt_put(val.length() >> 0);    //データ長 最下位バイト | Data length Least significant byte
  gt_put(val.length() >> 8);    //データ長 下位バイト | Data length second byte
  gt_put(val.length() >> 16);   //データ長 上位バイト | Data length third byte
  gt_put(val.length() >> 24);   //データ長 最上位バイト| Data length Most significant byte
  gt_print(val);       //文字列送信
}
 
////////////////////////////////////////////////////
// 1byte送信 | Send byte to GT-SP
////////////////////////////////////////////////////
void gt_put(unsigned char onebyte) {
  while (digitalRead(GT_DTR) == HIGH) {} // busycheck
  Serial.write(onebyte);
}
 
////////////////////////////////////////////////////
// 文字列送信 | Send String to GT-SP
////////////////////////////////////////////////////
void gt_print(String val) {
  int val_i;
  // 文字列を1文字ずつ送信 | Send string per one byte
  for (val_i = 0; val_i < val.length(); val_i++) {
    while (digitalRead(GT_DTR) == HIGH) {} // busycheck
    Serial.print(val.substring(val_i, val_i + 1));
  }
}