#include <string.h> 
//ピン接続 | Pin assign
#define GT_DTR      4      //DTR
#define GT_DSR      6      //DSR
#define GT_TRDY     7      //TRDY <--未使用 | unused in this sample

#define LED_PIN     2      //LED


void setup() {
    //ピン初期設定 | Pin setting
    pinMode(GT_DTR, INPUT);
    pinMode(GT_DSR, OUTPUT);
    pinMode(GT_TRDY, INPUT);

    pinMode(LED_PIN, OUTPUT); // D2ピンを出力に設定 | Output D2 pin

    digitalWrite(GT_DSR, LOW);

    //Serial setting
    Serial.begin(38400);    //38400bps Baud rate
    Serial.setTimeout(100); //シリアルタイムアウト | Serial timeout    
}

//変数 | Variable
int gtsp_res_data_val;
bool screen_reflesh = false; //画面再描画フラグ | Display refresh flag

////////////////////////////////////////////////////
// loop
////////////////////////////////////////////////////

void loop() {
 if ( Serial.available() ) {
    gtsp_res_data_val = gtsp_signal_read_val();
    screen_reflesh = true;
    Serial.println(gtsp_res_data_val);

     if(gtsp_res_data_val == 1){ // 受信した値が1だった場合 | If the value received is 1
      digitalWrite(LED_PIN, HIGH); // LEDを点灯 | Turn on LED
        Serial.print("CMD");   //コマンドヘッダ | Command header
        Serial.write(0x58);    //輝度設定 | Brightness setting
        Serial.write(0xFF);    //輝度50% | Brightness 50%
    } 
    if(gtsp_res_data_val == 0){ // 受信した値が0だった場合 | If the value received is 0
      digitalWrite(LED_PIN, LOW); // LEDを消灯 | Turn off LED
        Serial.print("CMD");   //コマンドヘッダ | Command header
        Serial.write(0x58);    //輝度設定 | Brightness setting
        Serial.write(0x80);    //輝度50% | Brightness 50%
    }
  }
}
/********************** 関数 | Function **********************/

////////////////////////////////////////////////////
//  データ受信(数値用) | Receive data from GT-SP (for Value)
//  (バイト長4バイトまで | Byte length is up to 4 byte)
////////////////////////////////////////////////////
unsigned long gtsp_signal_read_val(){

  byte res_dl[4] = "";
  unsigned long dl;
  byte res_val[4] = "";
  unsigned long val;

  if (Serial.find("RESb", 4)){
    Serial.readBytes(res_dl, 4); //データ長抽出 | Read data length
    dl = (unsigned long)(res_dl[0] + (res_dl[1]<<8) + (res_dl[2]<<16) + (res_dl[3]<<24)); //データ長変換 | Data length
    Serial.readBytes(res_val, dl); //データ抽出 | Read data
    val = (unsigned long)(res_val[0] + (res_val[1]<<8) + (res_val[2]<<16) + (res_val[3]<<24)); //データ抽出 | Read data
    return val; //リターン | Return 
  }
}
