#include <string.h>  // 必要なヘッダーファイルをインクルード | Include necessary header files
#include "DHT.h"     // DHTセンサー用のライブラリをインクルード | Include library for DHT sensor

// ピン設定 | Pin assignments
#define GT_DTR 4 //DTR
#define GT_DSR 6 //DSR
#define GT_TRDY 7 //TRDY <--未使用 | unused in this sample

#define DHT_SENSOR_PIN 10   // DHTセンサーのデータピン | Data pin for DHT sensor
#define DHT_SENSOR_TYPE DHT11  // 使用するDHTセンサーの型 | Type of DHT sensor being used

//変数 | Variable
float temperature;   //温度 | Temperature
float humidity;      //湿度 | Humidity

DHT dht(DHT_SENSOR_PIN, DHT_SENSOR_TYPE);  // DHTセンサーオブジェクトを作成 | Create DHT sensor object

////////////////////////////////////////////////////
// setup
////////////////////////////////////////////////////
void setup() {
  // ピン初期設定 | Pin settings
  pinMode(GT_DTR, INPUT);
  pinMode(GT_DSR, OUTPUT);
  pinMode(GT_TRDY, INPUT);
  digitalWrite(GT_TRDY, LOW);

  // シリアル通信設定 | Serial communication settings
  Serial.begin(38400);       // 38400bps Baud rate
  Serial.setTimeout(100);    // シリアルタイムアウト | Serial timeout    
  dht.begin();               // DHTセンサーの初期化 | Initialize DHT sensor
}

////////////////////////////////////////////////////
// loop
////////////////////////////////////////////////////
void loop() {

  //温度と湿度の取得 | Get temperature and humidity
  temperature = dht.readTemperature(false); // trueならば華氏 それ以外は摂氏 | Fahrenheit if true, Celsius otherwise
  humidity = dht.readHumidity();

  if (isnan(humidity) || isnan(temperature)) {
    // センサーからの読み取りエラー時のメッセージ出力 | Output error message for sensor read failure
    gtsp_ObjPrpSet_string(1, 0x40, "Error");  //Object No.1 / 0x40 = Text0
    gtsp_ObjPrpSet_string(3, 0x40, "Error");  //Object No.3 / 0x40 = Text0
  }
  else{
    //温度と湿度の出力 | Output temperature and humidity
    gtsp_ObjPrpSet_string(1, 0x40, String(temperature,1) + " deg C");   //Object No.1 / 0x40 = Text0
    gtsp_ObjPrpSet_string(3, 0x40, String(humidity,0) + " %");          //Object No.3 / 0x40 = Text0
  }

  delay(2000);
}

/********************** 関数 | Function **********************/
////////////////////////////////////////////////////
//  オブジェクト制御コマンド - プロパティ設定 (文字列用) | Object Control Command - Property Setting (for String)
////////////////////////////////////////////////////
void gtsp_ObjPrpSet_string(int obj, int prp, String val )
{
  gt_print("CMD");     //コマンドヘッダ | Command header
  gt_put(0xd3);        //オブジェクト-プロパティ設定コマンド | Object-Property Setting
  gt_put(obj >> 0);    //オブジェクトNo. 下位バイト | Object No. Lower byte
  gt_put(obj >> 8);    //オブジェクトNo. 上位バイト| Object No. Upper byte
  gt_put(prp >> 0);    //プロパティNo. 下位バイト | Property No. Lower byte 
  gt_put(prp >> 8);    //プロパティNo. 上位バイト| Property No. Upper byte 
  gt_put(val.length() >> 0);    //データ長 最下位バイト | Data length Least significant byte
  gt_put(val.length() >> 8);    //データ長 下位バイト | Data length second byte
  gt_put(val.length() >> 16);   //データ長 上位バイト | Data length third byte
  gt_put(val.length() >> 24);   //データ長 最上位バイト| Data length Most significant byte
  gt_print(val);       //文字列送信 | character string transmission
}

////////////////////////////////////////////////////
//  1byte送信 | Send byte to GT-SP
////////////////////////////////////////////////////
void gt_put(unsigned char onebyte)
{
  while ( digitalRead(GT_DTR) == HIGH ) {}  //busycheck
  Serial.write(onebyte);
}

////////////////////////////////////////////////////
//  文字列送信 | Send String to GT-SP
////////////////////////////////////////////////////
void gt_print(String val)
{
  int val_i;
  //文字列を1文字ずつ送信 | Send string per one byte
  for (val_i = 0; val_i < val.length(); val_i++)
  {
    while ( digitalRead(GT_DTR) == HIGH ) {}  //busycheck
    Serial.print(val.substring(val_i, val_i+1));
  }
}
