
// ピン接続 | Pin assign
#define GT_DTR 4      // DTR
#define GT_DSR 6      // DSR
#define GT_TRDY 7     // TRDY <--未使用 | unused in this sample
#define LED1 9        // RED LED
#define LED2 10       // Green LED
#define LED3 11       // Blue LED
 
 
// LEDチェック状態の保管変数
bool LED1Check = false; // LED1のチェック状態 | LED1 status
bool LED2Check = false; // LED2のチェック状態 | LED2 status
bool LED3Check = false; // LED3のチェック状態 | LED3 status
 
// 点滅モードの保管変数 | Blinking Mode Storage Variables
unsigned long BlinkingMode = 0; // 0: Solid on, 1: Blinking
 
// 点滅状態フラグ | Blinking state flag
bool BlinkingStatus = false;
 
// DEMOモードの状態を示す変数 | Variable indicating DEMO mode status
int demoMode = -1; // -1: OFF, 0: DEMO1, 1: DEMO2
 
// 時間管理 | Time Management
unsigned long lastBlinkTime;
unsigned long lastDemoUpdateTime;
const unsigned long blinkInterval = 500; // 点滅間隔（ミリ秒）| Blinking interval (milliseconds)
const unsigned long demoInterval = 1000; // DEMO更新間隔（ミリ秒）| DEMO update interval (milliseconds)
 
 
// 初期設定 | Initial Setup
void setup() {
  Serial.begin(38400);
  pinMode(LED1, OUTPUT);
  pinMode(LED2, OUTPUT);
  pinMode(LED3, OUTPUT);
  Serial.println("Setup completed. Waiting for data...");
  lastBlinkTime = millis();
  lastDemoUpdateTime = millis();
}
 
// メインループ | Main Loop
void loop() {
 
  // ボタンタッチ時の処理 | Processing when a button is touched
  if (Serial.available() > 0) {
 
    //データの取得 | Get Data
    String commandData = gtsp_signal_read();
    Serial.println("Received command: " + commandData);
 
    // 押されたボタンの判別 | Identification of button pressed
    if (commandData.startsWith("CHK")) {
      updateLED();
    } else if (commandData.startsWith("RAD")) { // ラジオボタンの状態を確認 | Check radio button status
      updateBlinkingMode();
    } else if (commandData.startsWith("DROP")) { // DEMOモードの状態を確認 | Check DEMO mode status
      updateDemo();
    }
  }
 
  //LEDの点灯処理 | LED lighting process
  if (demoMode == -1) {
    handleLED(); // 通常のLED点灯制御 | Normal LED lighting control
  } else {
    runDemo(); // DEMOモードの実行 | Running DEMO mode
  }
}
 
 
//LEDチェックボックス状態の確認関数 | LED checkbox status check function
void updateLED(){
  LED1Check = gtsp_ObjPrpRead_val(3, 0x10, 4);  //チェックボックスRedのVAL値読み出し | Read the VAL value of checkbox Red
  LED2Check = gtsp_ObjPrpRead_val(4, 0x10, 4);  //チェックボックスGreenのVAL値読み出し | Read the VAL value of checkbox Green
  LED3Check = gtsp_ObjPrpRead_val(5, 0x10, 4);  //チェックボックスBlueのVAL値読み出し | Read the VAL value of checkbox Blue
  demoMode = -1; // DEMOモードを停止 | Stop DEMO mode
}
 
//LED点滅モードラジオボタン選択状態の確認関数 | LED blinking mode radio button selection status confirmation function
void updateBlinkingMode(){
  BlinkingMode = gtsp_ObjPrpRead_val(1, 0x10, 4);  //ラジオボタンのVAL値読み出し | Read the VAL value of radio button
  demoMode = -1; // DEMOモードを停止 | Stop DEMO mode
}
 
//デモモードドロップダウン選択状態の確認関数 | Demo mode drop-down selection status confirmation function
void updateDemo(){
  demoMode = gtsp_ObjPrpRead_val(7, 0x10, 4);  //ドロップダウンのVAL値読み出し | Read the VAL value of drop-down
}
 
 
// LED点灯制御を行う関数 | LED lighting control function
void handleLED() {
  //点滅状態フラグの制御 | Controls blinking status flags
  unsigned long currentTime = millis();
  if (BlinkingMode == 1 && currentTime - lastBlinkTime >= blinkInterval) {  //LED点滅モード　かつ　消灯時間となるとき | If LED blinking mode and light off time
    if (BlinkingStatus == true) {BlinkingStatus = false;} else {BlinkingStatus = true;} //点滅状態フラグ入れ替え | Blinking status flag replacement
    lastBlinkTime = currentTime;
  }
 
  //LED点滅の制御 | LED blinking control
  if (BlinkingMode == 1 && BlinkingStatus == false) { //LED点滅モード　かつ　点滅状態フラグOFFのとき | If LED blinking mode and blinking status flag is OFF
    digitalWrite(LED1, LOW);
    digitalWrite(LED2, LOW);
    digitalWrite(LED3, LOW);
  }
  else{ //LED常時点灯モード　まはた　点滅状態フラグONのとき | LED always on mode or blinking status flag is ON
    if (LED1Check == 1){digitalWrite(LED1, HIGH);} else {digitalWrite(LED1, LOW);}
    if (LED2Check == 1){digitalWrite(LED2, HIGH);} else {digitalWrite(LED2, LOW);}
    if (LED3Check == 1){digitalWrite(LED3, HIGH);} else {digitalWrite(LED3, LOW);}
  }
}
 
 
// Running DEMO mode function
void runDemo() {
  unsigned long currentTime = millis();
  if (currentTime - lastDemoUpdateTime >= demoInterval) {
    lastDemoUpdateTime = currentTime;
    if (demoMode == 0) { // DEMO1
      static int currentLED = LED1;
      digitalWrite(LED1, LOW);
      digitalWrite(LED2, LOW);
      digitalWrite(LED3, LOW);
      digitalWrite(currentLED, HIGH);
      if (currentLED == LED1) currentLED = LED2;
      else if (currentLED == LED2) currentLED = LED3;
      else if (currentLED == LED3) currentLED = LED1;
    } else if (demoMode == 1) { // DEMO2
      static int currentLED = LED3;
      digitalWrite(LED1, LOW);
      digitalWrite(LED2, LOW);
      digitalWrite(LED3, LOW);
      digitalWrite(currentLED, HIGH);
      if (currentLED == LED3) currentLED = LED2;
      else if (currentLED == LED2) currentLED = LED1;
      else if (currentLED == LED1) currentLED = LED3;
    }
  }
}
 
 
 
 
 
 
/********************** GT-SP関数 | Function for GT-SP **********************/
////////////////////////////////////////////////////
// オブジェクト制御コマンド-プロパティ読み出し（数値用）| Read property value (for Value)
////////////////////////////////////////////////////
unsigned long gtsp_ObjPrpRead_val(int obj, int prp, int ln) {
  unsigned long val;
 
  gt_print("CMD");        // コマンドヘッダ | Command header
  gt_put(0xd4);           // オブジェクト-プロパティ設定コマンド | Object-Property Setting
  gt_put(obj >> 0);       // オブジェクトNo. 下位バイト | Object No. Lower byte
  gt_put(obj >> 8);       // オブジェクトNo. 上位バイト | Object No. Upper byte
  gt_put(prp >> 0);       // プロパティNo. 下位バイト | Property No. Lower byte
  gt_put(prp >> 8);       // プロパティNo. 上位バイト | Property No. Upper byte
  gt_put(ln >> 0);        // データ長 最下位バイト | Data length Least significant byte
  gt_put(ln >> 8);        // データ長 下位バイト | Data length second byte
  gt_put(ln >> 16);       // データ長 上位バイト | Data length third byte
  gt_put(ln >> 24);       // データ長 最上位バイト | Data length Most significant byte
 
  // プロパティデータ受信 | Property data received
  while (Serial.available() == 0) {}
  val = gtsp_signal_read_val();
  return val;
}
 
 
////////////////////////////////////////////////////
//  データ受信（文字列用） | Receive data from GT-SP (for String)
////////////////////////////////////////////////////
String gtsp_signal_read() {
  byte res_dl[4] = "";
  unsigned long dl;
  char res_data_char[255] = "";
 
  if (Serial.find("RESb", 4)) {
    Serial.readBytes(res_dl, 4); // データ長抽出 | Data-length extraction
    dl = (unsigned long)(res_dl[0] + (res_dl[1] << 8) + (res_dl[2] << 16) + (res_dl[3] << 24)); // データ長変換 | Data length
    Serial.readBytes(res_data_char, dl); // データ抽出 | Read data
    Serial.print("Received data: ");
    for (unsigned int i = 0; i < dl; i++) {
      Serial.print(res_data_char[i], HEX);
      Serial.print(" ");
    }
    Serial.println();
    return String(res_data_char); // String型変換、リターン | String type conversion, return
  }
  return "";
}
 
////////////////////////////////////////////////////
//  1byte送信 | Send byte to GT-SP
////////////////////////////////////////////////////
void gt_put(unsigned char onebyte)
{
  while ( digitalRead(GT_DTR) == HIGH ) {}  //busycheck
  Serial.write(onebyte);
}
 
////////////////////////////////////////////////////
//  文字列送信 | Send String to GT-SP
////////////////////////////////////////////////////
void gt_print(String val)
{
  int val_i;
  //文字列を1文字ずつ送信 | Send string per one byte
  for (val_i = 0; val_i < val.length(); val_i++)
  {
    while ( digitalRead(GT_DTR) == HIGH ) {}  //busycheck
    Serial.print(val.substring(val_i, val_i+1));
  }
}
 
////////////////////////////////////////////////////
//  データ受信(数値用) | Receive data from GT-SP (for Value)
//  (バイト長4バイトまで | Byte length is up to 4 byte)
////////////////////////////////////////////////////
unsigned long gtsp_signal_read_val(){
 
  byte res_dl[4] = "";
  unsigned long dl;
  byte res_val[4] = "";
  unsigned long val;
 
  if (Serial.find("RESb", 4)){
    Serial.readBytes(res_dl, 4); //データ長抽出 | Read data length
    dl = (unsigned long)(res_dl[0] + (res_dl[1]<<8) + (res_dl[2]<<16) + (res_dl[3]<<24)); //データ長変換 | Data length
    Serial.readBytes(res_val, dl); //データ抽出 | Read data
    val = (unsigned long)(res_val[0] + (res_val[1]<<8) + (res_val[2]<<16) + (res_val[3]<<24)); //データ抽出 | Read data
    return val; //リターン | Return 
  }
}