/****************************************
GT-SP(800x480) Sample for Start Guide
スタートガイド用サンプルプログラム

TFT module : GTWV070S3A00P
CPU board  : Arduino Nano Every

UART (GT Japmper  J5,J6:short)
Baudrate：38400bps

Port
<Arduino>    <GTWV070S3A00P>
D5            1:/RESET :Disused
TX            3:RXD
D4            4:DTR
D6            5:DSR
RX            6:TXD
D7            7:TRDY :Disused
*****************************************/
#include <string.h> 

//ピン接続 | Pin assign
#define GT_DTR      4      //DTR
#define GT_DSR      6      //DSR
#define GT_RESET    5      //RESET
#define GT_TRDY     7      //TRDY <--未使用 | Disused

//変数 | Variable
int meter_frame=0;
int meter_counter=0;
int itron_frame=0;
unsigned long frame_speed = 50;

unsigned long meter[25]; 
unsigned long itron[20]; 






////////////////////////////////////////////////////
// setup
////////////////////////////////////////////////////
    
void setup()
{
    //ピン初期設定 | Pin setting
    pinMode(GT_DTR, INPUT);
    pinMode(GT_DSR, OUTPUT);
    pinMode(GT_RESET, OUTPUT);
    pinMode(GT_TRDY, INPUT);

    digitalWrite(GT_RESET, HIGH);
    digitalWrite(GT_DSR, LOW);

    //Serial setting
    Serial1.begin(38400);    //38400bps Baudrate
    Serial1.setTimeout(100); //シリアルタイムアウト | Serial timeout    

    //画像アドレス代入 | Set image addresses
    //画像アドレスは"animation_IMG.csv"を参照 | Refer "animation_IMG.csv" to get image addresses
    meter[0] = 0x00040020;
    meter[1] = 0x000538e0;
    meter[2] = 0x000671a0;
    meter[3] = 0x0007aa60;
    meter[4] = 0x0008e320;
    meter[5] = 0x000a1be0;
    meter[6] = 0x000b54a0;
    meter[7] = 0x000c8d60;
    meter[8] = 0x000dc620;
    meter[9] = 0x000efee0;
    meter[10] = 0x001037a0;
    meter[11] = 0x00117060;
    meter[12] = 0x0012a920;
    meter[13] = 0x0013e1e0;
    meter[14] = 0x00151aa0;
    meter[15] = 0x00165360;
    meter[16] = 0x00178c20;
    meter[17] = 0x0018c4e0;
    meter[18] = 0x0019fda0;
    meter[19] = 0x001b3660;
    meter[20] = 0x001c6f20;
    meter[21] = 0x001da7e0;
    meter[22] = 0x001ee0a0;
    meter[23] = 0x00201960;
    meter[24] = 0x00215220;

    itron[0] = 0x00228ae0;
    itron[1] = 0x00233ae0;
    itron[2] = 0x0023eae0;
    itron[3] = 0x00249ae0;
    itron[4] = 0x00254ae0;
    itron[5] = 0x0025fae0;
    itron[6] = 0x0026aae0;
    itron[7] = 0x00275ae0;
    itron[8] = 0x00280ae0;
    itron[9] = 0x0028bae0;
    itron[10] = 0x00296ae0;
    itron[11] = 0x002a1ae0;
    itron[12] = 0x002acae0;
    itron[13] = 0x002b7ae0;
    itron[14] = 0x002c2ae0;
    itron[15] = 0x002cdae0;
    itron[16] = 0x002d8ae0;
    itron[17] = 0x002e3ae0;
    itron[18] = 0x002eeae0;
    itron[19] = 0x002f9ae0;


}

////////////////////////////////////////////////////
// loop
////////////////////////////////////////////////////
void loop()
{


  //GT-SPデータ受信 | Receive one GT-SP response data
  if ( Serial1.available() ) {
    frame_speed = gtsp_signal_read_val(); //フレームスピード取得
  }




  //メーターアニメーション | Meter animation
  gtsp_ObjPrpSet_val(0, 0x48, 4, meter[meter_frame]); //画像切替 | Change image
  meter_frame++; //フレーム増加 | Increase frame count
  meter_counter++;
  gtsp_ObjPrpSet_string(2, 0x40, String(meter_counter)); //値表示
  if (meter_frame >= 24){meter_frame = 0;} //フレームリセット | Reset frame count

  //itronロゴアニメーション | itron logo animation
  gtsp_ObjPrpSet_val(1, 0x48, 4, itron[itron_frame]); //画像切替 | Change image
  itron_frame++; //フレーム増加 | Increase frame count
  if (itron_frame >= 20){itron_frame = 0;} //フレームリセット | Reset frame count

  //ディレイ | Delay
  delay (frame_speed);

}




/********************** 関数 | Function **********************/
////////////////////////////////////////////////////
//  オブジェクト制御コマンド-プロパティ設定（数値用） | Object Control Command -Property Setting (for Value)
//  (バイト長4バイトまで | Byte length is up to 4 byte)
////////////////////////////////////////////////////
void gtsp_ObjPrpSet_val(int obj, int prp, int ln, unsigned long val )
{
  gt_print("CMD");        //コマンドヘッダ | Command header
  gt_put(0xd3);           //オブジェクト-プロパティ設定コマンド | Object-Property Setting
  gt_put(obj >> 0);    //オブジェクトNo. 下位バイト | Object No. Lower byte
  gt_put(obj >> 8);    //オブジェクトNo. 上位バイト| Object No. Upper byte
  gt_put(prp >> 0 );    //プロパティNo. 下位バイト | Property No. Lower byte 
  gt_put(prp >> 8);    //プロパティNo. 上位バイト| Property No. Upper byte 
  gt_put(ln >> 0);             //データ長 最下位バイト | Data length Least significant byte
  gt_put(ln >> 8);     //データ長 下位バイト | Data length second byte
  gt_put(ln >> 16);   //データ長 上位バイト | Data length third byte
  gt_put(ln >> 24);         //データ長 最上位バイト| Data length Most significant byte        
  if (ln >=1){ gt_put(val >> 0); }             //データ 最下位バイト | Data Least significant byte
  if (ln >=2){ gt_put(val >> 8); }     //データ 下位バイト | Data second byte
  if (ln >=3){ gt_put(val >> 16); }   //データ 上位バイト | Data third byte
  if (ln >=4){ gt_put(val >> 24); }         //データ 最上位バイト| Data Most significant byte
}

////////////////////////////////////////////////////
//  オブジェクト制御コマンド - プロパティ設定 (文字列用)
////////////////////////////////////////////////////
void gtsp_ObjPrpSet_string(int obj, int prp, String val )
{
  gt_print("CMD");     //コマンドヘッダ | Command header
  gt_put(0xd3);        //オブジェクト-プロパティ設定コマンド | Object-Property Setting
  gt_put(obj >> 0);    //オブジェクトNo. 下位バイト | Object No. Lower byte
  gt_put(obj >> 8);    //オブジェクトNo. 上位バイト| Object No. Upper byte
  gt_put(prp >> 0);    //プロパティNo. 下位バイト | Property No. Lower byte 
  gt_put(prp >> 8);    //プロパティNo. 上位バイト| Property No. Upper byte 
  gt_put(val.length() >> 0);    //データ長 最下位バイト | Data length Least significant byte
  gt_put(val.length() >> 8);    //データ長 下位バイト | Data length second byte
  gt_put(val.length() >> 16);   //データ長 上位バイト | Data length third byte
  gt_put(val.length() >> 24);   //データ長 最上位バイト| Data length Most significant byte
  gt_print(val);       //文字列送信
}

////////////////////////////////////////////////////
//  オブジェクト制御コマンド-プロパティ読み出し（数値用） | Object Control Command -Property Read (for Value)
////////////////////////////////////////////////////
unsigned long gtsp_ObjPrpRead_val(int obj, int prp, int ln)
{
  unsigned long val;

  gt_print("CMD");        //コマンドヘッダ | Command header
  gt_put(0xd4);           //オブジェクト-プロパティ設定コマンド | Object-Property Setting
  gt_put(obj >> 0);    //オブジェクトNo. 下位バイト | Object No. Lower byte
  gt_put(obj >> 8);    //オブジェクトNo. 上位バイト| Object No. Upper byte
  gt_put(prp >> 0);    //プロパティNo. 下位バイト | Property No. Lower byte 
  gt_put(prp >> 8);    //プロパティNo. 上位バイト| Property No. Upper byte 
  gt_put(ln >> 0);             //データ長 最下位バイト | Data length Least significant byte
  gt_put(ln >> 8);     //データ長 下位バイト | Data length second byte
  gt_put(ln >> 16);   //データ長 上位バイト | Data length third byte
  gt_put(ln >> 24);         //データ長 最上位バイト| Data length Most significant byte    

  //プロパティデータ受信 | Receive property data
  while (Serial1.available()==0){}
  val = gtsp_signal_read_val();
  return val;
}

////////////////////////////////////////////////////
//  1byte送信 | Send byte to GT-SP
////////////////////////////////////////////////////
void gt_put(unsigned char onebyte)
{
  while ( digitalRead(GT_DTR) == HIGH ) {}  //busycheck
  Serial1.write(onebyte);
}

////////////////////////////////////////////////////
//  文字列送信 | Send String to GT-SP
////////////////////////////////////////////////////
void gt_print(String val)
{
  int val_i;
  //文字列を1文字ずつ送信 | Send string per one byte
  for (val_i = 0; val_i < val.length(); val_i++)
  {
    while ( digitalRead(GT_DTR) == HIGH ) {}  //busycheck
    Serial1.print(val.substring(val_i, val_i+1));
  }
}

////////////////////////////////////////////////////
//  データ受信（文字列用） | Receive data from GT-SP (for String)
////////////////////////////////////////////////////
String gtsp_signal_read(){

  byte res_dl[4] = "";
  unsigned long dl;
  char res_data_char[255]="";

  if (Serial1.find("RESb", 4)){
    Serial1.readBytes(res_dl, 4); //データ長抽出 | Read data length
    dl = (unsigned long)(res_dl[0] + (res_dl[1]<<8) + (res_dl[2]<<16) + (res_dl[3]<<24)); //データ長変換 | Data length
    Serial1.readBytes(res_data_char, dl); //データ抽出 | Read data
    return String(res_data_char); //String型変換、リターン | Return as String
  }
}

////////////////////////////////////////////////////
//  データ受信(数値用) | Receive data from GT-SP (for Value)
//  (バイト長4バイトまで | Byte length is up to 4 byte)
////////////////////////////////////////////////////
unsigned long gtsp_signal_read_val(){

  byte res_dl[4] = "";
  unsigned long dl;
  byte res_val[4] = "";
  unsigned long val;

  if (Serial1.find("RESb", 4)){
    Serial1.readBytes(res_dl, 4); //データ長抽出 | Read data length
    dl = (unsigned long)(res_dl[0] + (res_dl[1]<<8) + (res_dl[2]<<16) + (res_dl[3]<<24)); //データ長変換 | Data length
    Serial1.readBytes(res_val, dl); //データ抽出 | Read data
    val = (unsigned long)(res_val[0] + (res_val[1]<<8) + (res_val[2]<<16) + (res_val[3]<<24)); //データ抽出 | Read data
    return val; //リターン | Return 
  }

}

///////////////////////////////////////
/*
  gt_put(0x43); //C
  gt_put(0x4d); //M
  gt_put(0x44); //D
  gt_put(0xd3); //プロパティ設定
  gt_put(0x02); //オブジェクトNo. 下位バイト
  gt_put(0x00); //オブジェクトNo. 上位バイト
  gt_put(0x40); //プロパティNo. 下位バイト
  gt_put(0x00); //プロパティNo. 上位バイト
  gt_put(0x01); //データ長 最下位バイト
  gt_put(0x00); //データ長 下位バイト
  gt_put(0x00); //データ長 上位バイト
  gt_put(0x00); //データ長 最上位バイト
  gt_put(0x01); //データ
*/

