/****************************************
GT-SP(800x480) Sample for Start Guide
スタートガイド用サンプルプログラム

TFT module : GTWV070S3A00P
CPU board  : Arduino Nano Every

UART (GT Japmper  J5,J6:short)
Baudrate：38400bps

Port
<Arduino>    <GTWV070S3A00P>
D5            1:/RESET :Disused
TX            3:RXD
D4            4:DTR
D6            5:DSR
RX            6:TXD
D7            7:TRDY :Disused
*****************************************/
#include <string.h> 

//ページ&オブジェクトNo ヘッダー | PAGE & OBJECT No. header
#include "bar_graph_IDX.h" 

//ピン接続 | Pin assign
#define GT_DTR      4      //DTR
#define GT_DSR      6      //DSR
#define GT_TRDY     7      //TRDY <--未使用 | Disused

bool screen_reflesh = false; //画面再描画フラグ | Display refresh flug
unsigned long gtsp_res_val[20];
unsigned long status;
String gtsp_res_data;
int i;

////////////////////////////////////////////////////
// setup
////////////////////////////////////////////////////
    
void setup()
{
    //ピン初期設定 | Pin setting
    pinMode(GT_DTR, INPUT);
    pinMode(GT_DSR, OUTPUT);
    pinMode(GT_TRDY, INPUT);

    digitalWrite(GT_DSR, LOW);

    //Serial setting
    Serial1.begin(38400);    //38400bps Baudrate
    Serial1.setTimeout(100); //シリアルタイムアウト | Serial timeout    
}

////////////////////////////////////////////////////
// loop
////////////////////////////////////////////////////
void loop()
{

  //画面描画 | Screen update

  status = gtsp_ObjPrpRead_val(GUI_DEF_OBJ_BUTTON_1_NO, 0x11, 4); //STARTボタンのREG読み出し | Read REG of START button
  if (status == 1){ 
    //もしSTARTボタンが押されていれば(REG=1) | If pushed START button (REG=1)
    
    gtsp_res_val[19] = gtsp_ObjPrpRead_val(GUI_DEF_OBJ_BAR_19_NO, 0x10, 4); //BAR_19のVALUE読み出し | Read VALUE of BAR_19

    //グラフ値シフト | Shift graph value
    for (i=0; i < 19; i++){
      gtsp_res_val[i] = gtsp_res_val[i+1];
    }

    //グラフ描画
    gtsp_ObjPrpSet_val(GUI_DEF_OBJ_BAR_0_NO, 0x10, 4, gtsp_res_val[0]);
    gtsp_ObjPrpSet_val(GUI_DEF_OBJ_BAR_1_NO, 0x10, 4, gtsp_res_val[1]);
    gtsp_ObjPrpSet_val(GUI_DEF_OBJ_BAR_2_NO, 0x10, 4, gtsp_res_val[2]);
    gtsp_ObjPrpSet_val(GUI_DEF_OBJ_BAR_3_NO, 0x10, 4, gtsp_res_val[3]); 
    gtsp_ObjPrpSet_val(GUI_DEF_OBJ_BAR_4_NO, 0x10, 4, gtsp_res_val[4]);
    gtsp_ObjPrpSet_val(GUI_DEF_OBJ_BAR_5_NO, 0x10, 4, gtsp_res_val[5]);
    gtsp_ObjPrpSet_val(GUI_DEF_OBJ_BAR_6_NO, 0x10, 4, gtsp_res_val[6]);
    gtsp_ObjPrpSet_val(GUI_DEF_OBJ_BAR_7_NO, 0x10, 4, gtsp_res_val[7]);
    gtsp_ObjPrpSet_val(GUI_DEF_OBJ_BAR_8_NO, 0x10, 4, gtsp_res_val[8]);
    gtsp_ObjPrpSet_val(GUI_DEF_OBJ_BAR_9_NO, 0x10, 4, gtsp_res_val[9]);
    gtsp_ObjPrpSet_val(GUI_DEF_OBJ_BAR_10_NO, 0x10, 4, gtsp_res_val[10]);
    gtsp_ObjPrpSet_val(GUI_DEF_OBJ_BAR_11_NO, 0x10, 4, gtsp_res_val[11]);
    gtsp_ObjPrpSet_val(GUI_DEF_OBJ_BAR_12_NO, 0x10, 4, gtsp_res_val[12]);
    gtsp_ObjPrpSet_val(GUI_DEF_OBJ_BAR_13_NO, 0x10, 4, gtsp_res_val[13]);
    gtsp_ObjPrpSet_val(GUI_DEF_OBJ_BAR_14_NO, 0x10, 4, gtsp_res_val[14]);
    gtsp_ObjPrpSet_val(GUI_DEF_OBJ_BAR_15_NO, 0x10, 4, gtsp_res_val[15]);
    gtsp_ObjPrpSet_val(GUI_DEF_OBJ_BAR_16_NO, 0x10, 4, gtsp_res_val[16]);
    gtsp_ObjPrpSet_val(GUI_DEF_OBJ_BAR_17_NO, 0x10, 4, gtsp_res_val[17]);
    gtsp_ObjPrpSet_val(GUI_DEF_OBJ_BAR_18_NO, 0x10, 4, gtsp_res_val[18]);

    delay(50);
   
  }


  
}

/********************** 関数 | Function **********************/
////////////////////////////////////////////////////
//  オブジェクト制御コマンド-プロパティ設定（数値用） | Object Control Command -Property Setting (for Value)
//  (バイト長4バイトまで | Byte length is up to 4 byte)
////////////////////////////////////////////////////
void gtsp_ObjPrpSet_val(int obj, int prp, int ln, unsigned long val )
{
  gt_print("CMD");        //コマンドヘッダ | Command header
  gt_put(0xd3);           //オブジェクト-プロパティ設定コマンド | Object-Property Setting
  gt_put(obj >> 0);    //オブジェクトNo. 下位バイト | Object No. Lower byte
  gt_put(obj >> 8);    //オブジェクトNo. 上位バイト| Object No. Upper byte
  gt_put(prp >> 0 );    //プロパティNo. 下位バイト | Property No. Lower byte 
  gt_put(prp >> 8);    //プロパティNo. 上位バイト| Property No. Upper byte 
  gt_put(ln >> 0);             //データ長 最下位バイト | Data length Least significant byte
  gt_put(ln >> 8);     //データ長 下位バイト | Data length second byte
  gt_put(ln >> 16);   //データ長 上位バイト | Data length third byte
  gt_put(ln >> 24);         //データ長 最上位バイト| Data length Most significant byte        
  if (ln >=1){ gt_put(val >> 0); }             //データ 最下位バイト | Data Least significant byte
  if (ln >=2){ gt_put(val >> 8); }     //データ 下位バイト | Data second byte
  if (ln >=3){ gt_put(val >> 16); }   //データ 上位バイト | Data third byte
  if (ln >=4){ gt_put(val >> 24); }         //データ 最上位バイト| Data Most significant byte
}

////////////////////////////////////////////////////
//  オブジェクト制御コマンド - プロパティ設定 (文字列用)
////////////////////////////////////////////////////
void gtsp_ObjPrpSet_string(int obj, int prp, String val )
{
  gt_print("CMD");        //コマンドヘッダ | Command header
  gt_put(0xd3);           //オブジェクト-プロパティ設定コマンド | Object-Property Setting
  gt_put(obj >> 0);    //オブジェクトNo. 下位バイト | Object No. Lower byte
  gt_put(obj >> 8);    //オブジェクトNo. 上位バイト| Object No. Upper byte
  gt_put(prp >> 0);    //プロパティNo. 下位バイト | Property No. Lower byte 
  gt_put(prp >> 8);    //プロパティNo. 上位バイト| Property No. Upper byte 
  gt_put(val.length() >> 0);             //データ長 最下位バイト | Data length Least significant byte
  gt_put(val.length() >> 8);     //データ長 下位バイト | Data length second byte
  gt_put(val.length() >> 16);   //データ長 上位バイト | Data length third byte
  gt_put(val.length() >> 24);         //データ長 最上位バイト| Data length Most significant byte
  gt_print(val);          //文字列送信
}


////////////////////////////////////////////////////
//  オブジェクト制御コマンド-プロパティ読み出し（数値用） | Object Control Command -Property Read (for Value)
////////////////////////////////////////////////////
unsigned long gtsp_ObjPrpRead_val(int obj, int prp, int ln)
{
  unsigned long val;

  gt_print("CMD");        //コマンドヘッダ | Command header
  gt_put(0xd4);           //オブジェクト-プロパティ設定コマンド | Object-Property Setting
  gt_put(obj >> 0);    //オブジェクトNo. 下位バイト | Object No. Lower byte
  gt_put(obj >> 8);    //オブジェクトNo. 上位バイト| Object No. Upper byte
  gt_put(prp >> 0);    //プロパティNo. 下位バイト | Property No. Lower byte 
  gt_put(prp >> 8);    //プロパティNo. 上位バイト| Property No. Upper byte 
  gt_put(ln >> 0);             //データ長 最下位バイト | Data length Least significant byte
  gt_put(ln >> 8);     //データ長 下位バイト | Data length second byte
  gt_put(ln >> 16);   //データ長 上位バイト | Data length third byte
  gt_put(ln >> 24);         //データ長 最上位バイト| Data length Most significant byte    

  //プロパティデータ受信 | Receive property data
  while (Serial1.available()==0){}
  val = gtsp_signal_read_val();
  return val;
}

////////////////////////////////////////////////////
//  1byte送信 | Send byte to GT-SP
////////////////////////////////////////////////////
void gt_put(unsigned char onebyte)
{
  while ( digitalRead(GT_DTR) == HIGH ) {}  //busycheck
  Serial1.write(onebyte);
}

////////////////////////////////////////////////////
//  文字列送信 | Send String to GT-SP
////////////////////////////////////////////////////
void gt_print(String val)
{
  int val_i;
  //文字列を1文字ずつ送信 | Send string per one byte
  for (val_i = 0; val_i < val.length(); val_i++)
  {
    while ( digitalRead(GT_DTR) == HIGH ) {}  //busycheck
    Serial1.print(val.substring(val_i, val_i+1));
  }
}

////////////////////////////////////////////////////
//  データ受信（文字列用） | Receive data from GT-SP (for String)
////////////////////////////////////////////////////
String gtsp_signal_read(){

  byte res_dl[4] = "";
  unsigned long dl;
  char res_data_char[255]="";

  if (Serial1.find("RESb", 4)){
    Serial1.readBytes(res_dl, 4); //データ長抽出 | Read data length
    dl = (unsigned long)(res_dl[0] + (res_dl[1]<<8) + (res_dl[2]<<16) + (res_dl[3]<<24)); //データ長変換 | Data length
    Serial1.readBytes(res_data_char, dl); //データ抽出 | Read data
    return String(res_data_char); //String型変換、リターン | Return as String
  }
}

////////////////////////////////////////////////////
//  データ受信(数値用) | Receive data from GT-SP (for Value)
//  (バイト長4バイトまで | Byte length is up to 4 byte)
////////////////////////////////////////////////////
unsigned long gtsp_signal_read_val(){

  byte res_dl[4] = "";
  unsigned long dl;
  byte res_val[4] = "";
  unsigned long val;

  if (Serial1.find("RESb", 4)){
    Serial1.readBytes(res_dl, 4); //データ長抽出 | Read data length
    dl = (unsigned long)(res_dl[0] + (res_dl[1]<<8) + (res_dl[2]<<16) + (res_dl[3]<<24)); //データ長変換 | Data length
    Serial1.readBytes(res_val, dl); //データ抽出 | Read data
    val = (unsigned long)(res_val[0] + (res_val[1]<<8) + (res_val[2]<<16) + (res_val[3]<<24)); //データ抽出 | Read data
    return val; //リターン | Return 
  }

}

