/*********************************************************
 * This program is intended to provide a simple communication example
 * using a generic USB driver with a Noritake GT-1P module.
 * 
 * Created by: Noritake Support
 * Date: 7/25/19
 * Contact: support.ele@noritake.com
 * 
 * Website: www.noritake-elec.com
 * (C) 2019 Noritake Co., Inc.
 * 
 * Disclaimer: This software example is provided "AS-IS". We are not
 * responsible for any issues that may occur while using this program.
 * This software is intended for demonstration and evaluation purposes
 * only.
 * 
 * Need to use the following terminal commands to set up generic USB 
 * driver:
 * sudo modprobe -r usbserial
 * sudo modprobe usbserial vendor=0x0EDA product=0x12DD
 *********************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <unistd.h>
#include <ctype.h>

// GT-CP module device path
#define GTCP_MODULE "/dev/ttyUSB0"

// Interfacing handles
int readHandle;
int writeHandle;

//Brightness Globals
int MAX_BRIGHTNESS = 100;
int MIN_BRIGHTNESS = 1;

/**
 * Upper case string converter
 * Helper function
 */
void stringUpper(char *strg)
{
	while(*strg)
	{
		*strg = toupper(*strg);
		strg++;
	}
}

/**
 * Set module brightness
 * 
 * @param   brightnessVal  The desired brightness value.
 * @returns none
 */
void setBrightness(char brightnessVal)
{
	char command[] = {
		0x1f, 0x58, brightnessVal
	};
	write(writeHandle, command, 3);
}

int main(int argc, char *argv[])
{
	double brightness = atoi(argv[1]);
	
	printf("Brightness: %f\n", brightness);
	
	if(argc == 2)
	{
		if(brightness > MAX_BRIGHTNESS || brightness < MIN_BRIGHTNESS)
		{
			// Exit program
			exit(-1);
		} else {
			
			// Convert brightness value
			brightness /= 100;
			brightness *= 255;
			
			// Connect to module's read handle
			readHandle = open(GTCP_MODULE, O_RDONLY | O_NOCTTY);
			if(readHandle < 0)
			{
				perror(GTCP_MODULE);
				exit(-1);
			}
			
			// Connect to module's write handle
			writeHandle = open(GTCP_MODULE, O_WRONLY | O_NOCTTY | O_NONBLOCK);
			if(writeHandle < 0)
			{
				perror(GTCP_MODULE);
				exit(-1);
			}
			
			// Change brightness
			setBrightness((char)brightness);
			
			// Close both module handles
			close(readHandle);
			close(writeHandle);
		}
	}
	return 1;
}


