/*********************************************************
 * Filename: GT1P.h
 * 
 * Purpose:
 * Provide functions directly relating to the GT-1P's
 * commands to be used via USB connection on a Linux
 * platform. 
 * 
 * Version: 3.0 (ME-N63-01)
 * Date: 9/19/2018
 * Website: noritake-elec.com
 * (C) 2019 Noritake Co., Inc.
 *********************************************************/

#ifndef GT1P_H
#define GT1P_H

void GT1P_productStatusSendBoot(unsigned char * bootData);
void GT1P_productStatusSendFirm(unsigned char * firmData);
void GT1P_productStatusSendMemCheck(char address, char length, unsigned char * memCheckData);
void GT1P_productStatusSendProdType(unsigned char * prodData);
void GT1P_productStatusSendWidth(unsigned char * widthData);
void GT1P_productStatusSendHeight(unsigned char * heightData);
void GT1P_productStatusSendTSPName(unsigned char * TSPNameData);
void GT1P_productStatusSendTSPID(unsigned char * TSPIDData);
void GT1P_setBrightness(char level);
void GT1P_setThreshold(char level);
void GT1P_setTSRSetting(char value, char numbers, unsigned char * data);
void GT1P_setTSRUsage(char enable);
char GT1P_setTSRUsageStatusRead(void);
void GT1P_storeTSP(char dest, unsigned char *TSPfile);
void GT1P_selectTSP(char num);
void GT1P_memorySWSetting(char memorySW, char data);
char GT1P_getMemorySWSetting(char memorySW);
void GT1P_Init();
void GT1P_enableTouch(char enable);
void GT1P_setTouchMode(char numTouch);

#endif
