/*********************************************************
 * Filename: GT1P_USB_LIB.h
 * 
 * Purpose:
 * Provide wrapper functions to communicate with GT-1P
 * modules via libusb.h.
 * 
 * Version: 3.0 (ME-N63-01)
 * Date: 9/19/2018
 * Website: noritake-elec.com
 * (C) 2019 Noritake Co., Inc.
 *********************************************************/

#ifndef GT1P_USB_LIB_H
#define GT1P_USB_LIB_H

#define ACM_CTRL_DTR 0x01
#define ACM_CTRL_RTS 0x02

//Product ID Global Variable
extern int product_ID;

int USB_start(void);
int USB_get_active();
void write_char(unsigned char c);
void write_multi_char(unsigned char * data);
void write_data(unsigned char * data, int size);
int read_USB(unsigned char * data, int size);
void release_USB();

#endif
