/*********************************************************
 * This program is intended to provide a simple communication example
 * using libusb.h with a Noritake GT-1P module.
 * 
 * Created by: Noritake Support
 * Date: 7/25/19
 * Contact: support.ele@noritake.com
 * 
 * Website: www.noritake-elec.com
 * (C) 2019 Noritake Co., Inc.
 * 
 * Disclaimer: This software example is provided "AS-IS". We are not
 * responsible for any issues that may occur while using this program.
 * This software is intended for demonstration and evaluation purposes
 * only.
 *********************************************************/

#include <libusb-1.0/libusb.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "GT1P.h"
#include "GT1P_USB_LIB.h"

//Product ID definitions
#define GTWV050VHB00P 0x12dd
#define GT800X480A_1303P 0x12de
#define GT1280X800A_1303P 0x12df

//Product ID Global Variable
//Extern source found in GT1P_USB_LIB.h
int product_ID;

//Brightness Globals
int MAX_BRIGHTNESS = 100;
int MIN_BRIGHTNESS = 1;

void stringUpper(char *strg)
{
	while(*strg)
	{
		*strg = toupper(*strg);
		strg++;
	}
}

int main(int argc, char *argv[])
{
	double brightness = atoi(argv[1]);
	
	printf("Brightness: %f\n", brightness);
	
	if(argc == 3)
	{
		if(brightness > MAX_BRIGHTNESS || brightness < MIN_BRIGHTNESS)
		{
			// Exit program
			exit(-1);
		} else {
			// Change brightness
			stringUpper(argv[2]);
			if(!strcmp(argv[2], "GTWV050VHB00P"))
			{
				// 5 inch GT-1P connected
				product_ID = GTWV050VHB00P;
			} else if(!strcmp(argv[2], "GT800X480A_1303P"))
			{
				// 7 inch GT-1P connected
				product_ID = GT800X480A_1303P;
			} else if(!strcmp(argv[2], "GT1280X800A_1303P"))
			{
				// 10.1 inch GT-1P connected
				product_ID = GT1280X800A_1303P;
			} else {
				printf("No module chosen. Program will exit.");
				exit(-1);
			}
			
			// Convert brightness value
			brightness /= 100;
			brightness *= 255;
			
			// Connect to module, change brightness, and release module
			if(!USB_start())
			{
				GT1P_setBrightness((char)brightness);
				release_USB();
			}
		}
	}
	return 1;
}


