/*********************************************************
 * Purpose:
 * Provide functions directly relating to the GT-CP's
 * commands to be used via USB connection on a Linux
 * platform. 
 * 
 * Version: 1.0
 * Website: noritake-elec.com
 *********************************************************/

#ifndef GUTFT_H
#define GUTFT_H

void GUTFT_Init();
void GUTFT_putChar(char c);
void GUTFT_putString(unsigned char * data);
void GUTFT_displayOFF();
void GUTFT_displayON();
void GUTFT_drawLineBox(char mode, char pen, unsigned xStart, unsigned yStart, unsigned xEnd, unsigned yEnd);
void GUTFT_drawImage(unsigned xSize, unsigned ySize, char format, unsigned char * data, unsigned imageSize);
void GUTFT_enableTouch(uint8_t enable);
void GUTFT_multiTouchMode(char numTouch);
void GUTFT_coordinatesMode(uint8_t channel);
void GUTFT_customSwitchModeSingle(char channel, unsigned xPos, unsigned yPos, unsigned xSize, unsigned ySize);
void GUTFT_back();
void GUTFT_forward();
void GUTFT_lineFeed();
void GUTFT_home();
void GUTFT_carriageReturn();
void GUTFT_crlf();
void GUTFT_XY(unsigned x, unsigned y);
void GUTFT_setCursor(unsigned x, unsigned y);
void GUTFT_clearScreen();
void GUTFT_lineClear();
void GUTFT_lineEndClear();
void GUTFT_cursorON();
void GUTFT_writeScreenMode(char mode);
void GUTFT_writeMixtureDisplayMode(char mode);
void GUTFT_useMultiByteChars(char enable);
void GUTFT_setMultiByteCharSet(char code);
void GUTFT_useCustomChars(char enable);
void GUTFT_defineCustomChar(char codeStart, char codeEnd, char format, char xDir, unsigned char * data);
void GUTFT_deleteCustomChar(char type, char code);
void GUTFT_setAsciiVariant(char code);
void GUTFT_setCharSet(char code);
void GUTFT_setScrollMode(char mode);
void GUTFT_setHorizScrollSpeed(char speed);
void GUTFT_invertOFF();
void GUTFT_invertON();
void GUTFT_setCompositionMode(char mode);
void GUTFT_setScreenBrightness(unsigned level);
void GUTFT_wait(char wait);
void GUTFT_shortWait(char time);
void GUTFT_scrollScreen(unsigned x, unsigned y, unsigned times, char speed);
void GUTFT_curtainAction(char direction, char speed, char red, char green, char blue);
void GUTFT_springAction(char direction, char speed, unsigned x, unsigned y);
void GUTFT_randomAction(char actionType, char speed, unsigned x, unsigned y);
void GUTFT_fadeInAction(char speed, unsigned x, unsigned y);
void GUTFT_fadeOutAction(char speed);
void GUTFT_blinkScreenOFF();
void GUTFT_blinkScreenON(char enable, char reverse, char onTime, char offTime, char cycles);
void GUTFT_screenSaver(char mode);
void GUTFT_setFontStyle(char proportional, char evenSpacing);
void GUTFT_setOutlineFontSize(unsigned charLineHeight, unsigned nominalCharY, unsigned nominalcharX, unsigned baseOffsetY);
void GUTFT_setOutlineFontType(char fontType);
void GUTFT_setFontMagnification(char x, char y);
void GUTFT_setCharacterStyle(char style);
void GUTFT_setCharacterColor(char red, char green, char blue);
void GUTFT_backgroundColorEnable(char enable);
void GUTFT_setBackgroundColor(char red, char green, char blue);
void GUTFT_setShadowBorderingColor(char red, char green, char blue);
void GUTFT_setBackground(char enable);
void GUTFT_selectWindow(char window);
void GUTFT_defineWindow(char window, unsigned x, unsigned y, unsigned width, unsigned height);
void GUTFT_deleteWindow(char window);
void GUTFT_joinScreens();
void GUTFT_separateScreens();
void GUTFT_storedBitImageDraw(char memory, unsigned  address, unsigned extension, unsigned xDefine, unsigned xSize, unsigned ySize, char format);
void GUTFT_pixelDrawing(char pen, unsigned x, unsigned y);
void GUTFT_switchMatrixMode(char channel, char switchesX, char switchesY, char clearanceX, char clearanceY);
void GUTFT_IOPortSetting(char portNumber, char portSetting);
void GUTFT_IOPortOutput(char portNumber, char portValue);
void GUTFT_IOPortInput(char portNumber);
void GUTFT_memorySWSetting(char memorySW, char data);
void GUTFT_memorySWSettingMulti(char numSettings, unsigned char * data);
void GUTFT_memorySWDataSend(char switchNum);
void GUTFT_memorySWDataSendMulti(char numReads, unsigned char * data);
void GUTFT_16x16CharacterDefinition(char codeUpper, char codeLower, unsigned char * data);
void GUTFT_16x16CharacterDelete(char codeUpper, char codeLower);
void GUTFT_32x32CharacterDefinition(char codeUpper, char codeLower, unsigned char * data);
void GUTFT_32x32CharacterDelete(char codeUpper, char codeLower);
void GUTFT_downloadCharacterSave(char fontSize);
void GUTFT_downloadCharacterRestore(char fontSize);
void GUTFT_enterUserSetupMode();
void GUTFT_endUserSetupMode();
void GUTFT_FROMUserFontDefinition(char table, unsigned char * data);
void GUTFT_RAMMacroDefineDelete(char lengthUpper, char lengthLower, unsigned char * data);
void GUTFT_FROMMacroDefineDelete(char registrationNum, char lengthUpper, char lengthLower, char interval, char idleTime, unsigned char * data);
void GUTFT_macroExecution(char definitionNum, char interval, char idleTime);
void GUTFT_macroEndCondition(char endCodeEnable, uint8_t endCode, uint8_t endScreenSetting);
void GUTFT_memoryStore(unsigned size, uint8_t memorySelect, uint8_t addressUpper, uint8_t addressLower, uint8_t addressExtension, unsigned char * data);
void GUTFT_memoryTransfer(uint8_t sizeUpper, uint8_t sizeLower, uint8_t sizeExtension, uint8_t destMemory, uint8_t destAddressUpper, uint8_t destAddressLower, uint8_t destAddressExtension, uint8_t srcMemory, uint8_t srcAddressUpper, uint8_t srcAddressLower, uint8_t srcAddressExtension);


#endif
