/****************************************
GT-SP(800x480) Sample for Start Guide
スタートガイド用サンプルプログラム

TFT module : GTWV070S3A00P
CPU board  : Arduino Nano Every

UART (GT Japmper  J5,J6:short)
Baudrate：38400bps

Port
<Arduino>    <GTWV070S3A00P>
D5            1:/RESET :Disused
TX            3:RXD
D4            4:DTR
D6            5:DSR
RX            6:TXD
D7            7:TRDY :Disused
*****************************************/
#include <string.h> 

//ピン接続 | Pin assign
#define GT_DTR      4      //DTR
#define GT_DSR      6      //DSR
#define GT_TRDY     7      //TRDY <--未使用 | Disused

////////////////////////////////////////////////////
// setup
////////////////////////////////////////////////////
    
void setup()
{
    //ピン初期設定 | Pin setting
    pinMode(GT_DTR, INPUT);
    pinMode(GT_DSR, OUTPUT);
    pinMode(GT_TRDY, INPUT);

    digitalWrite(GT_DSR, LOW);

    //Serial setting
    Serial1.begin(38400);    //38400bps Baudrate
    Serial1.setTimeout(100); //シリアルタイムアウト | Serial timeout    
}

////////////////////////////////////////////////////
// loop
////////////////////////////////////////////////////
void loop()
{
  //オブジェクト制御コマンド-プロパティ設定 | Object Control Command -Property Setting
  Serial1.print("CMD");   //コマンドヘッダ | Command header
  Serial1.write(0xD3);    //オブジェクト-プロパティ設定 | Object-Property Setting
  Serial1.write(0x00);    //オブジェクトNo. 下位バイト | Object No. Lower byte
  Serial1.write(0x00);    //オブジェクトNo. 上位バイト| Object No. Upper byte
  Serial1.write(0x40);    //プロパティNo. 下位バイト | Property No. Lower byte 
  Serial1.write(0x00);    //プロパティNo. 上位バイト| Property No. Upper byte 
  Serial1.write(0x0B);    //データ長 最下位バイト | Data length Least significant byte
  Serial1.write(0x00);    //データ長 下位バイト | Data length second byte
  Serial1.write(0x00);    //データ長 上位バイト | Data length third byte
  Serial1.write(0x00);    //データ長 最上位バイト| Data length Most significant byte
  Serial1.print("Hello World"); //データ | Data


  //全体制御コマンド-輝度設定 (50%) | Control Command - Brightness Setting
  Serial1.print("CMD");   //コマンドヘッダ | Command header
  Serial1.write(0x58);    //輝度設定 | Brightness setting
  Serial1.write(0x80);    //輝度50% | Brightness 50%
  delay(500);

  //全体制御コマンド-輝度設定 (100%) | Control Command - Brightness Setting
  Serial1.print("CMD");  //コマンドヘッダ | Command header
  Serial1.write(0x58);   //輝度設定 | Brightness setting
  Serial1.write(0xFF);   //輝度100% | Brightness 100%
  delay(500);
}



