/****************************************
GT-SP(800x480) Sample for Start Guide
スタートガイド用サンプルプログラム

TFT module : GTWV070S3A00P
CPU board  : Arduino Nano Every

UART (GT Japmper  J5,J6:short)
Baudrate：38400bps

Port
<Arduino>    <GTWV070S3A00P>
D5            1:/RESET :Disused
TX            3:RXD
D4            4:DTR
D6            5:DSR
RX            6:TXD
D7            7:TRDY :Disused
*****************************************/
#include <string.h> 

//ピン接続 | Pin assign
#define GT_DTR      4      //DTR
#define GT_DSR      6      //DSR
#define GT_TRDY     7      //TRDY <--未使用 | Disused

//変数 | Variable
String gtsp_res_data;
bool screen_reflesh = false; //画面再描画フラグ | Display refresh flag

////////////////////////////////////////////////////
// setup
////////////////////////////////////////////////////
    
void setup()
{
    //ピン初期設定 | Pin setting
    pinMode(GT_DTR, INPUT);
    pinMode(GT_DSR, OUTPUT);
    pinMode(GT_TRDY, INPUT);

    digitalWrite(GT_DSR, LOW);

    //Serial setting
    Serial1.begin(38400);    //38400bps Baudrate
    Serial1.setTimeout(100); //シリアルタイムアウト | Serial timeout    
}

////////////////////////////////////////////////////
// loop
////////////////////////////////////////////////////
void loop()
{

  //GT-SPデータ受信 | Receive one GT-SP response data
  if ( Serial1.available() ) {
    gtsp_res_data = gtsp_signal_read();
    screen_reflesh = true;
  }

  //画面描画 | Screen update
  if (screen_reflesh == true){
    gtsp_ObjPrpSet_string(1, 0x40, gtsp_res_data);
  }
  screen_reflesh = false;
}

/********************** 関数 | Function **********************/
////////////////////////////////////////////////////
//  オブジェクト制御コマンド-プロパティ設定（文字列用） | Object Control Command -Property Setting (String)
////////////////////////////////////////////////////
void gtsp_ObjPrpSet_string(int obj, int prp, String val )
{
  gt_print("CMD");     //コマンドヘッダ | Command header
  gt_put(0xd3);        //オブジェクト-プロパティ設定コマンド | Object-Property Setting
  gt_put(obj >> 0);    //オブジェクトNo. 下位バイト | Object No. Lower byte
  gt_put(obj >> 8);    //オブジェクトNo. 上位バイト| Object No. Upper byte
  gt_put(prp >> 0);    //プロパティNo. 下位バイト | Property No. Lower byte 
  gt_put(prp >> 8);    //プロパティNo. 上位バイト| Property No. Upper byte 
  gt_put(val.length() >> 0);    //データ長 最下位バイト | Data length Least significant byte
  gt_put(val.length() >> 8);    //データ長 下位バイト | Data length second byte
  gt_put(val.length() >> 16);   //データ長 上位バイト | Data length third byte
  gt_put(val.length() >> 24);   //データ長 最上位バイト| Data length Most significant byte
  gt_print(val);       //文字列送信
}

////////////////////////////////////////////////////
//  1byte送信 | Send byte to GT-SP
////////////////////////////////////////////////////
void gt_put(unsigned char onebyte)
{
  while ( digitalRead(GT_DTR) == HIGH ) {}  //busycheck
  Serial1.write(onebyte);
}

////////////////////////////////////////////////////
//  文字列送信 | Send String to GT-SP
////////////////////////////////////////////////////
void gt_print(String val)
{
  int val_i;
  //文字列を1文字ずつ送信 | Send string per one byte
  for (val_i = 0; val_i < val.length(); val_i++)
  {
    while ( digitalRead(GT_DTR) == HIGH ) {}  //busycheck
    Serial1.print(val.substring(val_i, val_i+1));
  }
}

////////////////////////////////////////////////////
//  データ受信（文字列用） | Receive data from GT-SP (for String)
////////////////////////////////////////////////////
String gtsp_signal_read(){

  byte res_dl[4] = "";
  unsigned long dl;
  char res_data_char[255]="";

  if (Serial1.find("RESb", 4)){
    Serial1.readBytes(res_dl, 4); //データ長抽出 | Read data length
    dl = (unsigned long)(res_dl[0] + (res_dl[1]<<8) + (res_dl[2]<<16) + (res_dl[3]<<24)); //データ長変換 | Data length
    Serial1.readBytes(res_data_char, dl); //データ抽出 | Read data
    return String(res_data_char); //String型変換、リターン | Return as String
  }
}

